/////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND Key_hWnd = NULL;

    static HMENU SystemMenu     = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(MainDialog_hWnd, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1002, "www.NetWorkDLS.com");

        SendMessage(MainDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(MainDialog_hWnd, WM_SETICON, TRUE, (LPARAM)LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        Key_hWnd = GetDlgItem(MainDialog_hWnd, 1000);

        CenterWindow(MainDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 1500) //- Remove current key (Dialog Command)
        {
            if( IsDlgButtonChecked(MainDialog_hWnd, 1500) )
                EnableWindow(Key_hWnd, FALSE);
            else EnableWindow(Key_hWnd, TRUE);
            return 0;
        }

        if(wParam == 100) //- Okay (Dialog Command)
        {
            if( IsDlgButtonChecked(MainDialog_hWnd, 1500) )
            {
                if(!Set_BinaryRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "KeyHash", NULL, 0))
                {
                    MessageBox(MainDialog_hWnd, "An error occured setting the registry key.", TitleCaption, 0);
                    return 0;
                }

                MessageBox(MainDialog_hWnd, "The exesting key has been removed.", TitleCaption, 0);

                EndDialog(MainDialog_hWnd,0);
                DestroyWindow(MainDialog_hWnd);

                return 0;
            }

            char Key[10240 + 1];
            int Size = 0;

            Size = Get_TextEx(Key_hWnd, Key, 10240);

            if(Size < 8 || Size > 10240)
            {
                MessageBox(MainDialog_hWnd, "You must enter a key between 8 and 10,240 characters long.", TitleCaption, 0);
                return 0;
            }

            if(HashKey(Key, Size, 128))
            {
                MessageBox(MainDialog_hWnd, "The new key hash is now in place.", TitleCaption, 0);

                EndDialog(MainDialog_hWnd,0);
                DestroyWindow(MainDialog_hWnd);
            }

            return 0;
        }

        if(wParam == 101) //- Exit (Dialog Command)
        {
            EndDialog(MainDialog_hWnd,0);
            DestroyWindow(MainDialog_hWnd);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            NetLogo(MainDialog_hWnd);
            return 0;
        }

        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s", TitleCaption, FileVersion);
            MessageBox(MainDialog_hWnd, VersionText, "Application Version", MB_TASKMODAL);
            return 0;
        }

        if(LOWORD(wParam) == 1002) //- www.NetWorkDLS.com (SysMenu Command)
        {
            ShellExecute(0,"Open", "Http://www.NetWorkDLS.com", NULL, NULL, SW_SHOWNORMAL);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(MainDialog_hWnd,0);
        DestroyWindow(MainDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
//////////////////////////////////////////////////////////////////////

